"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addFeeStatus = exports.fetchAllFeeStatus = exports.deleteFee = exports.addFee = exports.fetchAllFees = exports.deleteIncome = exports.updateIncome = exports.addIncome = exports.fetchAllIncome = exports.deleteExpense = exports.updateExpense = exports.addExpense = exports.fetchAllExpense = exports.deleteAccountCategory = exports.addAccountCategory = exports.fetchAccountCategory = void 0;
const services_1 = require("../services");
//category
const fetchAccountCategory = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _accountCatgory = yield (0, services_1.getAccountCategory)();
        res.status(200).json(_accountCatgory);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAccountCategory = fetchAccountCategory;
const addAccountCategory = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const accountCategoryData = req.body;
    try {
        const _accountCatgory = yield (0, services_1.createAccountCategory)(accountCategoryData);
        res.status(201).json({
            message: "Account Category added successfully",
            data: _accountCatgory
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addAccountCategory = addAccountCategory;
const deleteAccountCategory = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const accountCategoryId = req.params.accountCategoryId;
    try {
        const _accountCatgory = yield (0, services_1.removeAccountCategory)(accountCategoryId);
        res.status(200).json({
            message: "Account Category deleted successfully",
            data: _accountCatgory
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteAccountCategory = deleteAccountCategory;
//expense
const fetchAllExpense = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _expense = yield (0, services_1.getAllExpense)();
        res.status(200).json(_expense);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllExpense = fetchAllExpense;
const addExpense = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const expenseData = req.body;
    try {
        const _expense = yield (0, services_1.createExpense)(expenseData);
        res.status(201).json({
            message: "Expense added successfully",
            data: _expense
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addExpense = addExpense;
const updateExpense = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const expenseId = req.params.expenseId;
    const expenseData = req.body;
    try {
        const _expense = yield (0, services_1.editExpense)(expenseId, expenseData);
        res.status(201).json({
            message: "Expense updated successfully",
            data: _expense
        });
    }
    catch (error) {
        next(error);
    }
});
exports.updateExpense = updateExpense;
const deleteExpense = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const expenseId = req.params.expenseId;
    try {
        const _expense = yield (0, services_1.removeExpense)(expenseId);
        res.status(200).json({
            message: "Expense deleted successfully",
            data: _expense
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteExpense = deleteExpense;
//income
const fetchAllIncome = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _income = yield (0, services_1.getAllIncome)();
        res.status(200).json(_income);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllIncome = fetchAllIncome;
const addIncome = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const incomeData = req.body;
    try {
        const _income = yield (0, services_1.createIncome)(incomeData);
        res.status(201).json({
            message: "Income added successfully",
            data: _income
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addIncome = addIncome;
const updateIncome = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const incomeId = req.params.incomeId;
    const incomeData = req.body;
    try {
        const _income = yield (0, services_1.editIncome)(incomeId, incomeData);
        res.status(201).json({
            message: "Income updated successfully",
            data: _income
        });
    }
    catch (error) {
        next(error);
    }
});
exports.updateIncome = updateIncome;
const deleteIncome = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const incomeId = req.params.incomeId;
    try {
        const _income = yield (0, services_1.removeIncome)(incomeId);
        res.status(200).json({
            message: "Income deleted successfully",
            data: _income
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteIncome = deleteIncome;
//fees
const fetchAllFees = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _fees = yield (0, services_1.getAllFees)();
        res.status(200).json(_fees);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllFees = fetchAllFees;
const addFee = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const feeData = req.body;
    try {
        const _fee = yield (0, services_1.createFee)(feeData);
        res.status(201).json({
            message: "Fee added successfully",
            data: _fee
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addFee = addFee;
const deleteFee = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const feeData = req.body;
    try {
        const _fee = yield (0, services_1.removeFee)(feeData);
        res.status(200).json({
            message: "Fee deleted successfully",
            data: _fee
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteFee = deleteFee;
//fee status
const fetchAllFeeStatus = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _status = yield (0, services_1.getAllFeeStatus)();
        console.log(_status);
        res.status(200).json(_status);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllFeeStatus = fetchAllFeeStatus;
const addFeeStatus = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const feeData = req.body;
    try {
        const _status = yield (0, services_1.createOrUpdateFeeStatus)(feeData);
        console.log(_status);
        res.status(200).json({
            message: "Fee changed successfully",
            data: _status
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addFeeStatus = addFeeStatus;
