"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteClassFee = exports.updateClassFee = exports.addClassFee = exports.fetchClassFee = exports.deleteSection = exports.addSection = exports.fetchAllSection = exports.deleteClass = exports.updateClass = exports.addClass = exports.fetchOneClass = exports.fetchAllClass = exports.fetchTotals = void 0;
const services_1 = require("../services");
const totals_1 = require("../services/totals");
const fetchTotals = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const [_classTotal, _studentTotal, _staffTotal] = yield Promise.all([
            (0, totals_1.getTotalClass)(),
            (0, totals_1.getTotalStudents)(),
            (0, totals_1.getTotalStaff)()
        ]);
        const _result = {
            studentTotal: _studentTotal,
            staffTotal: _staffTotal,
            classTotal: _classTotal
        };
        res.status(200).json(_result);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchTotals = fetchTotals;
const fetchAllClass = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _class = yield (0, services_1.getAllClass)();
        res.status(200).json(_class);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllClass = fetchAllClass;
const fetchOneClass = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classId = req.params.classId;
    try {
        const _class = yield (0, services_1.getClassById)(classId);
        res.status(200).json(_class);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchOneClass = fetchOneClass;
const addClass = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classData = req.body;
    try {
        const _class = yield (0, services_1.createClass)(classData);
        res.status(201).json({
            message: "Class added successfully",
            data: _class
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addClass = addClass;
const updateClass = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classId = req.params.classId;
    const classData = req.body;
    try {
        const _class = yield (0, services_1.editClass)(classId, classData);
        res.status(201).json({
            message: "Class updated successfully",
            data: _class
        });
    }
    catch (error) {
        next(error);
    }
});
exports.updateClass = updateClass;
const deleteClass = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classId = req.params.classId;
    try {
        const _class = yield (0, services_1.removeClass)(classId);
        res.status(200).json({
            message: "Class deleted successfully",
            data: _class
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteClass = deleteClass;
//section
const fetchAllSection = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const _section = yield (0, services_1.getAllSection)();
        res.status(200).json(_section);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllSection = fetchAllSection;
const addSection = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const sectionData = req.body;
    try {
        const _section = yield (0, services_1.createSection)(sectionData);
        res.status(201).json({
            message: "Class section added successfully",
            data: _section
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addSection = addSection;
const deleteSection = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const sectionId = req.params.sectionId;
    try {
        const _section = yield (0, services_1.removeSection)(sectionId);
        res.status(200).json({
            message: "Class section deleted successfully",
            data: _section
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteSection = deleteSection;
//class fees
const fetchClassFee = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classId = req.params.classId;
    try {
        const _classFee = yield (0, services_1.getClassFee)(classId);
        res.status(200).json(_classFee);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchClassFee = fetchClassFee;
const addClassFee = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classFeeData = req.body;
    try {
        const _classFee = yield (0, services_1.createClassFee)(classFeeData);
        res.status(201).json({
            message: "Class fee added successfully",
            data: _classFee
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addClassFee = addClassFee;
const updateClassFee = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classFeeId = req.params.classFeeId;
    const classFeeData = req.body;
    try {
        const _classFee = yield (0, services_1.editClassFee)(classFeeId, classFeeData);
        res.status(201).json({
            message: "Class fee updated successfully",
            data: _classFee
        });
    }
    catch (error) {
        next(error);
    }
});
exports.updateClassFee = updateClassFee;
const deleteClassFee = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const classFeeId = req.params.classFeeId;
    try {
        const _classFee = yield (0, services_1.removeClassFee)(classFeeId);
        res.status(200).json({
            message: "Class fee deleted successfully",
            data: _classFee
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteClassFee = deleteClassFee;
