"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteStaff = exports.updateStaff = exports.addStaff = exports.fetchOneStaff = exports.fetchAllStaff = void 0;
const services_1 = require("../services");
const fetchAllStaff = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const staff = yield (0, services_1.getAllStaff)();
        // console.log("staff:::", staff)
        res.status(200).json({ message: "Staff data successful", data: staff });
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllStaff = fetchAllStaff;
const fetchOneStaff = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const staffId = req.params.staffId;
    try {
        const staff = yield (0, services_1.getStaffById)(staffId);
        res.status(200).json({ message: "Staff data successful", data: staff });
    }
    catch (error) {
        next(error);
    }
});
exports.fetchOneStaff = fetchOneStaff;
const addStaff = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const staffData = req.body;
    try {
        const staff = yield (0, services_1.createStaff)(staffData);
        res.status(201).json({
            message: "Staff added successfully",
            data: staff
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addStaff = addStaff;
const updateStaff = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const staffId = req.params.staffId;
    const staffData = req.body;
    try {
        const staff = yield (0, services_1.editStaff)(staffId, staffData);
        res.status(201).json({
            message: "Staff updated successfully",
            data: staff
        });
    }
    catch (error) {
        next(error);
    }
});
exports.updateStaff = updateStaff;
const deleteStaff = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const staffId = req.params.staffId;
    try {
        const staff = yield (0, services_1.removeStaff)(staffId);
        res.status(200).json({
            message: "Staff deleted successfully",
            data: staff
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteStaff = deleteStaff;
