"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteStudent = exports.updateStudent = exports.addStudent = exports.fetchOneStudent = exports.fetchAllStudents = void 0;
const services_1 = require("../services");
const fetchAllStudents = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const students = yield (0, services_1.getAllStudents)();
        console.log(students);
        res.status(200).json(students);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllStudents = fetchAllStudents;
const fetchOneStudent = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const studentId = req.params.studentId;
    try {
        const students = yield (0, services_1.getStudentById)(studentId);
        res.status(200).json(students);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchOneStudent = fetchOneStudent;
const addStudent = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const studentData = req.body.studentData;
    const parentData = req.body.parentData;
    const user = req.user;
    try {
        // if (user.role !== "Administrator") {
        //     return res.status(401).send({ message: "Unauthorized to add student." });
        // }
        const student = yield (0, services_1.createStudent)(studentData);
        const _parentData = Object.assign(Object.assign({}, parentData), { studentId: student.studentId });
        const parent = yield (0, services_1.createParent)(_parentData);
        res.status(201).json({
            message: "Student added successfully",
            data: student
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addStudent = addStudent;
const updateStudent = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const studentId = req.params.studentId;
    const studentData = req.body.studentData;
    const parentData = req.body.parentData;
    try {
        const result = yield Promise.all([
            (0, services_1.editStudent)(studentId, studentData),
            (0, services_1.editParent)(studentId, parentData)
        ]);
        res.status(201).json({
            message: "Student updated successfully",
            data: result
        });
    }
    catch (error) {
        next(error);
    }
});
exports.updateStudent = updateStudent;
const deleteStudent = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const studentId = req.params.studentId;
    const user = req.user;
    try {
        // if (user.role !== "Administrator") {
        //     return res.status(401).send({ message: "Unauthorized to delete student" });
        // }
        const student = yield (0, services_1.removeStudent)(studentId);
        res.status(200).json({
            message: "Student deleted successfully",
            data: student
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteStudent = deleteStudent;
