"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteSubject = exports.updateSubject = exports.addSubject = exports.fetchOneSubject = exports.fetchAllSubject = void 0;
const services_1 = require("../services");
const fetchAllSubject = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const subject = yield (0, services_1.getAllSubject)();
        res.status(200).json(subject);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchAllSubject = fetchAllSubject;
const fetchOneSubject = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const subjectId = req.params.subjectId;
    try {
        const subject = yield (0, services_1.getSubjectById)(subjectId);
        res.status(200).json(subject);
    }
    catch (error) {
        next(error);
    }
});
exports.fetchOneSubject = fetchOneSubject;
const addSubject = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const subjectData = req.body;
    try {
        const subject = yield (0, services_1.createSubject)(subjectData);
        res.status(201).json({
            message: "Subject added successfully",
            data: subject
        });
    }
    catch (error) {
        next(error);
    }
});
exports.addSubject = addSubject;
const updateSubject = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const subjectId = req.params.subjectId;
    const subjectData = req.body;
    try {
        const subject = yield (0, services_1.editSubject)(subjectId, subjectData);
        res.status(201).json({
            message: "Subject updated successfully",
            data: subject
        });
    }
    catch (error) {
        next(error);
    }
});
exports.updateSubject = updateSubject;
const deleteSubject = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const subjectId = req.params.subjectId;
    try {
        const subject = yield (0, services_1.removeSubject)(subjectId);
        res.status(200).json({
            message: "Subject deleted successfully",
            data: subject
        });
    }
    catch (error) {
        next(error);
    }
});
exports.deleteSubject = deleteSubject;
