"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Class = void 0;
const sequelize_1 = require("sequelize");
class Class extends sequelize_1.Model {
    static initModel(sequelize) {
        return Class.init({
            classId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: false,
                unique: "name_UNIQUE"
            },
            capacity: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            sectionId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Section',
                    key: 'sectionId'
                }
            },
            staffId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Staff',
                    key: 'staffId'
                }
            }
        }, {
            sequelize,
            tableName: 'Class',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "classId" },
                    ]
                },
                {
                    name: "name_UNIQUE",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "name" },
                    ]
                },
                {
                    name: "fk_Class_Section1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "sectionId" },
                    ]
                },
                {
                    name: "fk_Class_Staff1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "staffId" },
                    ]
                },
            ]
        });
    }
}
exports.Class = Class;
