"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassFee = void 0;
const sequelize_1 = require("sequelize");
class ClassFee extends sequelize_1.Model {
    static initModel(sequelize) {
        return ClassFee.init({
            classFeesId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            amount: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
            // classId: {
            //   type: DataTypes.INTEGER,
            //   allowNull: true,
            //   references: {
            //     model: 'Class',
            //     key: 'classId'
            //   }
            // }
        }, {
            sequelize,
            tableName: 'ClassFees',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "classFeesId" },
                    ]
                },
                // {
                //   name: "fk_ClassFees_Class1_idx",
                //   using: "BTREE",
                //   fields: [
                //     { name: "classId" },
                //   ]
                // },
            ]
        });
    }
}
exports.ClassFee = ClassFee;
