"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Expense = void 0;
const sequelize_1 = require("sequelize");
class Expense extends sequelize_1.Model {
    static initModel(sequelize) {
        return Expense.init({
            expenseId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            description: {
                type: sequelize_1.DataTypes.TEXT,
                allowNull: true
            },
            amount: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
            staffId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Staff',
                    key: 'staffId'
                }
            },
            accountCategoryId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'AccountCategory',
                    key: 'accountCategoryId'
                }
            }
        }, {
            sequelize,
            tableName: 'Expense',
            timestamps: true,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "expenseId" },
                    ]
                },
                // {
                //   name: "fk_Expense_Staff1_idx",
                //   using: "BTREE",
                //   fields: [
                //     { name: "staffId" },
                //   ]
                // },
                // {
                //   name: "fk_Expense_AccountCategory1_idx",
                //   using: "BTREE",
                //   fields: [
                //     { name: "accountCategoryId" },
                //   ]
                // },
            ]
        });
    }
}
exports.Expense = Expense;
