"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fees = void 0;
const sequelize_1 = require("sequelize");
class Fees extends sequelize_1.Model {
    static initModel(sequelize) {
        return Fees.init({
            feeId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            studentId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Student',
                    key: 'studentId'
                }
            },
            classId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Class',
                    key: 'classId'
                }
            },
            total: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
            paid: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
            remaining: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
            paymentMode: {
                type: sequelize_1.DataTypes.TEXT,
                allowNull: true
            },
            amountInWords: {
                type: sequelize_1.DataTypes.TEXT,
                allowNull: true
            },
            term: {
                type: sequelize_1.DataTypes.TEXT,
                allowNull: true
            },
            datePaid: {
                type: sequelize_1.DataTypes.DATEONLY,
                allowNull: true
            }
        }, {
            sequelize,
            tableName: 'Fees',
            timestamps: true,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "feeId" },
                    ]
                },
            ]
        });
    }
}
exports.Fees = Fees;
