"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Parent = void 0;
const sequelize_1 = require("sequelize");
class Parent extends sequelize_1.Model {
    static initModel(sequelize) {
        return Parent.init({
            parentId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            fName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            lName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            gender: {
                type: sequelize_1.DataTypes.ENUM('Male', 'Female'),
                allowNull: true,
                defaultValue: "Male"
            },
            relationship: {
                type: sequelize_1.DataTypes.STRING(60),
                allowNull: true
            },
            occupation: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            contact: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: true
            },
            other_contact: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: true
            },
            email: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: true
            },
            address: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            studentId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Student',
                    key: 'studentId'
                }
            }
        }, {
            sequelize,
            tableName: 'Parent',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "parentId" },
                    ]
                },
                {
                    name: "fk_Parent_Student1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "studentId" },
                    ]
                },
            ]
        });
    }
}
exports.Parent = Parent;
