"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Staff = void 0;
const sequelize_1 = require("sequelize");
class Staff extends sequelize_1.Model {
    static initModel(sequelize) {
        return Staff.init({
            staffId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            fName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            mName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            lName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            email: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            contact: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: true
            },
            otherContact: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: true
            },
            gender: {
                type: sequelize_1.DataTypes.ENUM('Male', 'Female'),
                allowNull: true,
                defaultValue: "Male"
            },
            category: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            address: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            }
        }, {
            sequelize,
            tableName: 'Staff',
            timestamps: true,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "staffId" },
                    ]
                },
            ]
        });
    }
}
exports.Staff = Staff;
