"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Student = void 0;
const sequelize_1 = require("sequelize");
class Student extends sequelize_1.Model {
    static initModel(sequelize) {
        return Student.init({
            studentId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            fName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            mName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            lName: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            dob: {
                type: sequelize_1.DataTypes.DATEONLY,
                allowNull: true
            },
            classId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Class',
                    key: 'classId'
                }
            },
            gender: {
                type: sequelize_1.DataTypes.ENUM('Male', 'Female'),
                allowNull: true,
                defaultValue: "Male"
            },
            address: {
                type: sequelize_1.DataTypes.STRING(150),
                allowNull: true
            }
        }, {
            sequelize,
            tableName: 'Student',
            timestamps: true,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "studentId" },
                    ]
                },
                {
                    name: "fk_Student_Class_idx",
                    using: "BTREE",
                    fields: [
                        { name: "classId" },
                    ]
                },
            ]
        });
    }
}
exports.Student = Student;
