"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentFeeStatus = void 0;
const sequelize_1 = require("sequelize");
class StudentFeeStatus extends sequelize_1.Model {
    static initModel(sequelize) {
        return StudentFeeStatus.init({
            studentFeeStatusId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            studentId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Student',
                    key: 'studentId'
                }
            },
            feeOwing: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
            feePaid: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
        }, {
            sequelize,
            tableName: 'StudentFeeStatus',
            timestamps: true,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "studentFeeStatusId" },
                    ]
                },
                {
                    name: "fk_StudentFeeStatus_Student_idx",
                    using: "BTREE",
                    fields: [
                        { name: "studentId" },
                    ]
                },
            ]
        });
    }
}
exports.StudentFeeStatus = StudentFeeStatus;
