"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentTermlyAttendance = void 0;
const sequelize_1 = require("sequelize");
class StudentTermlyAttendance extends sequelize_1.Model {
    static initModel(sequelize) {
        return StudentTermlyAttendance.init({
            studentTermlyAttendanceId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            totalAttendance: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            totalPresent: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            totalSick: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            term: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            year: {
                type: sequelize_1.DataTypes.DATE,
                allowNull: true
            },
            classId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Class',
                    key: 'classId'
                }
            },
            studentId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Student',
                    key: 'studentId'
                }
            }
        }, {
            sequelize,
            tableName: 'StudentTermlyAttendance',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "studentTermlyAttendanceId" },
                    ]
                },
                {
                    name: "fk_StudentTermlyAttendance_Class1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "classId" },
                    ]
                },
                {
                    name: "fk_StudentTermlyAttendance_Student1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "studentId" },
                    ]
                },
            ]
        });
    }
}
exports.StudentTermlyAttendance = StudentTermlyAttendance;
