"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Subject = void 0;
const sequelize_1 = require("sequelize");
class Subject extends sequelize_1.Model {
    static initModel(sequelize) {
        return Subject.init({
            subjectId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: true
            },
            classMark: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            'class%': {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            examMark: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            'exam%': {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            passMark: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            }
        }, {
            sequelize,
            tableName: 'Subject',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "subjectId" },
                    ]
                },
            ]
        });
    }
}
exports.Subject = Subject;
