"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TermDetail = void 0;
const sequelize_1 = require("sequelize");
class TermDetail extends sequelize_1.Model {
    static initModel(sequelize) {
        return TermDetail.init({
            termDetailsId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            term: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            startDate: {
                type: sequelize_1.DataTypes.DATEONLY,
                allowNull: true
            },
            endDate: {
                type: sequelize_1.DataTypes.DATEONLY,
                allowNull: true
            }
        }, {
            sequelize,
            tableName: 'TermDetails',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "termDetailsId" },
                    ]
                },
            ]
        });
    }
}
exports.TermDetail = TermDetail;
