"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const sequelize_1 = require("sequelize");
class User extends sequelize_1.Model {
    static initModel(sequelize) {
        return User.init({
            userId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            password: {
                type: sequelize_1.DataTypes.TEXT,
                allowNull: true
            },
            staffId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Staff',
                    key: 'staffId'
                }
            },
            username: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            }
        }, {
            sequelize,
            tableName: 'User',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "userId" },
                    ]
                },
                {
                    name: "fk_User_Staff1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "staffId" },
                    ]
                },
            ]
        });
    }
}
exports.User = User;
