"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const controllers_1 = require("../controllers");
const classController_1 = require("../controllers/classController");
const generalRouter = express_1.default.Router();
//students
generalRouter.get("/all-students", controllers_1.fetchAllStudents);
generalRouter.get("/all-students/:studentId", controllers_1.fetchOneStudent);
generalRouter.post("/create-student", controllers_1.addStudent);
// generalRouter.post("/create-student", authenticateUser, addStudent);
generalRouter.put("/update-student/:studentId", controllers_1.updateStudent);
generalRouter.delete("/delete-student/:studentId", controllers_1.deleteStudent);
//staff
generalRouter.get("/all-staff", controllers_1.fetchAllStaff);
generalRouter.get("/all-staff/:staffId", controllers_1.fetchOneStaff);
generalRouter.post("/create-staff", controllers_1.addStaff);
generalRouter.put("/update-staff/:staffId", controllers_1.updateStaff);
generalRouter.delete("/delete-staff/:staffId", controllers_1.deleteStaff);
//class
generalRouter.get("/all-class", controllers_1.fetchAllClass);
generalRouter.get("/all-class/:classId", controllers_1.fetchOneClass);
generalRouter.post("/create-class", controllers_1.addClass);
generalRouter.put("/update-class/:classId", controllers_1.updateClass);
generalRouter.delete("/delete-class/:classId", controllers_1.deleteClass);
//--section--
generalRouter.get("/all-section", controllers_1.fetchAllSection);
generalRouter.post("/create-section", controllers_1.addSection);
generalRouter.delete("/delete-section/:sectionId", controllers_1.deleteSection);
//--class fee--
generalRouter.get("/class-fee/:classId", controllers_1.fetchClassFee);
generalRouter.post("/create-class-fee", controllers_1.addClassFee);
generalRouter.put("/update-class-fee/:classFeeId", controllers_1.updateClassFee);
generalRouter.delete("/delete-class-fee/:classFeeId", controllers_1.deleteClassFee);
//subject
generalRouter.get("/all-subject", controllers_1.fetchAllSubject);
generalRouter.get("/all-subject/:subjectId", controllers_1.fetchOneSubject);
generalRouter.post("/create-subject", controllers_1.addSubject);
generalRouter.put("/update-subject/:subjectId", controllers_1.updateSubject);
generalRouter.delete("/delete-subject/:subjectId", controllers_1.deleteSubject);
//account
//--category
generalRouter.get("/account/all-category", controllers_1.fetchAccountCategory);
generalRouter.post("/account/create-category", controllers_1.addAccountCategory);
generalRouter.delete("/account/delete-category/:accountCategoryId", controllers_1.deleteAccountCategory);
//--expense
generalRouter.get("/all-expense", controllers_1.fetchAllExpense);
generalRouter.post("/create-expense", controllers_1.addExpense);
generalRouter.put("/update-expense/:expenseId", controllers_1.updateExpense);
generalRouter.delete("/delete-expense/:expenseId", controllers_1.deleteExpense);
//--income
generalRouter.get("/all-income", controllers_1.fetchAllIncome);
generalRouter.post("/create-income", controllers_1.addIncome);
generalRouter.put("/update-income/:incomeId", controllers_1.updateIncome);
generalRouter.delete("/delete-income/:incomeId", controllers_1.deleteIncome);
//--fees status
generalRouter.get("/all-fee-status", controllers_1.fetchAllFeeStatus);
generalRouter.get("/set-fee-status", controllers_1.addFeeStatus);
//--fees
generalRouter.get("/all-fee", controllers_1.fetchAllFees);
generalRouter.post("/create-fee", controllers_1.addFee);
generalRouter.delete("/delete-fee", controllers_1.deleteFee);
//totals
generalRouter.get("/totals", classController_1.fetchTotals);
exports.default = generalRouter;
