"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeStaff = exports.editStaff = exports.createStaff = exports.getStaffById = exports.getAllStaff = void 0;
const models_1 = require("../models");
const getAllStaff = () => __awaiter(void 0, void 0, void 0, function* () {
    console.log(yield models_1.Staff.findAll({ raw: true }));
    return yield models_1.Staff.findAll({ raw: true });
});
exports.getAllStaff = getAllStaff;
const getStaffById = (staffId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Staff.findByPk(staffId);
});
exports.getStaffById = getStaffById;
const createStaff = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Staff.create(data);
});
exports.createStaff = createStaff;
const editStaff = (staffId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Staff.update(data, {
        where: {
            staffId: staffId,
        },
    });
});
exports.editStaff = editStaff;
const removeStaff = (staffId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Staff.destroy({
        where: {
            staffId: staffId,
        },
    });
});
exports.removeStaff = removeStaff;
