"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeSubject = exports.editSubject = exports.createSubject = exports.getSubjectById = exports.getAllSubject = void 0;
const models_1 = require("../models");
const getAllSubject = () => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Subject.findAll();
});
exports.getAllSubject = getAllSubject;
const getSubjectById = (subjectId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Subject.findByPk(subjectId);
});
exports.getSubjectById = getSubjectById;
const createSubject = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Subject.create(data);
});
exports.createSubject = createSubject;
const editSubject = (subjectId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Subject.update(data, {
        where: {
            subjectId: subjectId,
        },
    });
});
exports.editSubject = editSubject;
const removeSubject = (subjectId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Subject.destroy({
        where: {
            subjectId: subjectId,
        },
    });
});
exports.removeSubject = removeSubject;
