"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUser = exports.getUser = exports.checkUser = void 0;
const sequelize_1 = require("sequelize");
const models_1 = require("../models");
const checkUser = (data) => {
    return models_1.User.findOne({
        where: {
            [sequelize_1.Op.or]: [{ username: data.username }, { staffId: data.staffId ? data.staffId : data.username }]
        }
    });
};
exports.checkUser = checkUser;
const getUser = (data) => {
    return models_1.User.findOne({
        //(username = data.username or userId = data.staffId) and password = data.password
        where: {
            [sequelize_1.Op.or]: [{ username: data.username }, { staffId: data.username }],
        },
        include: {
            model: models_1.Staff,
            as: "staff",
        },
    });
};
exports.getUser = getUser;
const createUser = (data) => {
    return models_1.User.create(data);
};
exports.createUser = createUser;
