"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.login = exports.register = void 0;
const services_1 = require("../services");
const bcrypt_1 = __importDefault(require("bcrypt"));
const passport_config_1 = __importDefault(require("../utils/passport-config"));
const register = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const userDetails = req.body;
        const existingUser = yield (0, services_1.checkUser)(userDetails);
        if (existingUser) {
            return res.status(400).json({ message: "User already exist" });
        }
        const saltRounds = 10;
        const hashedPassword = yield bcrypt_1.default.hash(userDetails.password, saltRounds);
        const newUser = yield (0, services_1.createUser)(Object.assign(Object.assign({}, userDetails), { password: hashedPassword }));
        res.status(201).json({
            message: "Registration successful",
            data: newUser
        });
    }
    catch (error) {
        next(error);
    }
});
exports.register = register;
const login = (req, res, next) => {
    passport_config_1.default.authenticate("local", { session: false }, (err, user, info) => {
        if (err) {
            console.log(err);
            return res.status(500).json({ message: "Authentication error" });
        }
        if (!user) {
            return res.status(200).json({ message: "Invalid username or password" });
        }
        // Successful login, return the JWT token
        return res.status(200).json({ token: info.token });
    })(req, res, next);
};
exports.login = login;
