"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountCategory = void 0;
const sequelize_1 = require("sequelize");
class AccountCategory extends sequelize_1.Model {
    static initModel(sequelize) {
        return AccountCategory.init({
            accountCategoryId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            section: {
                type: sequelize_1.DataTypes.ENUM('Expense', 'Income'),
                allowNull: false,
                defaultValue: "Expense"
            }
        }, {
            sequelize,
            tableName: 'AccountCategory',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "accountCategoryId" },
                    ]
                },
            ]
        });
    }
}
exports.AccountCategory = AccountCategory;
