"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Income = void 0;
const sequelize_1 = require("sequelize");
class Income extends sequelize_1.Model {
    static initModel(sequelize) {
        return Income.init({
            incomeId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: sequelize_1.DataTypes.STRING(100),
                allowNull: true
            },
            description: {
                type: sequelize_1.DataTypes.TEXT,
                allowNull: true
            },
            amount: {
                type: sequelize_1.DataTypes.DECIMAL(65, 2),
                allowNull: true
            },
            staffId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'Staff',
                    key: 'staffId'
                }
            },
            accountCategoryId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true,
                references: {
                    model: 'AccountCategory',
                    key: 'accountCategoryId'
                }
            }
        }, {
            sequelize,
            tableName: 'Income',
            timestamps: true,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "incomeId" },
                    ]
                },
                // {
                //   name: "fk_Income_Staff1_idx",
                //   using: "BTREE",
                //   fields: [
                //     { name: "staffId" },
                //   ]
                // },
                // {
                //   name: "fk_Income_AccountCategory1_idx",
                //   using: "BTREE",
                //   fields: [
                //     { name: "accountCategoryId" },
                //   ]
                // },
            ]
        });
    }
}
exports.Income = Income;
