"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Section = void 0;
const sequelize_1 = require("sequelize");
class Section extends sequelize_1.Model {
    static initModel(sequelize) {
        return Section.init({
            sectionId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            name: {
                type: sequelize_1.DataTypes.STRING(45),
                allowNull: true
            }
        }, {
            sequelize,
            tableName: 'Section',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "sectionId" },
                    ]
                },
            ]
        });
    }
}
exports.Section = Section;
