"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentAttendance = void 0;
const sequelize_1 = require("sequelize");
class StudentAttendance extends sequelize_1.Model {
    static initModel(sequelize) {
        return StudentAttendance.init({
            studentAttendanceId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            status: {
                type: sequelize_1.DataTypes.ENUM('Present', 'Absent', 'Sick'),
                allowNull: true
            },
            term: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            dateMarked: {
                type: sequelize_1.DataTypes.DATEONLY,
                allowNull: true
            },
            studentId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Class',
                    key: 'classId'
                }
            },
            classId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Class',
                    key: 'classId'
                }
            }
        }, {
            sequelize,
            tableName: 'StudentAttendance',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "studentAttendanceId" },
                    ]
                },
                {
                    name: "fk_StudentAttendance_Class1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "classId" },
                    ]
                },
                {
                    name: "fk_StudentAttendance_Student1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "studentId" },
                    ]
                },
            ]
        });
    }
}
exports.StudentAttendance = StudentAttendance;
