"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentMark = void 0;
const sequelize_1 = require("sequelize");
class StudentMark extends sequelize_1.Model {
    static initModel(sequelize) {
        return StudentMark.init({
            studentMarksId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            classMark: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            examMark: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            remarks: {
                type: sequelize_1.DataTypes.STRING(50),
                allowNull: true
            },
            grade: {
                type: sequelize_1.DataTypes.STRING(5),
                allowNull: true
            },
            studentTermlyResultId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'StudentTermlyResult',
                    key: 'studentTermlyResultId'
                }
            },
            subjectId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Subject',
                    key: 'subjectId'
                }
            }
        }, {
            sequelize,
            tableName: 'StudentMarks',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "studentMarksId" },
                    ]
                },
                {
                    name: "fk_StudentMarks_StudentTermlyResults1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "studentTermlyResultId" },
                    ]
                },
                {
                    name: "fk_StudentMarks_Subject1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "subjectId" },
                    ]
                },
            ]
        });
    }
}
exports.StudentMark = StudentMark;
