"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentTermlyResult = void 0;
const sequelize_1 = require("sequelize");
class StudentTermlyResult extends sequelize_1.Model {
    static initModel(sequelize) {
        return StudentTermlyResult.init({
            studentTermlyResultId: {
                autoIncrement: true,
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                primaryKey: true
            },
            totalRawScore: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            passScore: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            rawScore: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            term: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: true
            },
            year: {
                type: sequelize_1.DataTypes.DATE,
                allowNull: true
            },
            dateCreated: {
                type: sequelize_1.DataTypes.DATE,
                allowNull: true
            },
            studentId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Student',
                    key: 'studentId'
                }
            },
            classId: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                references: {
                    model: 'Class',
                    key: 'classId'
                }
            }
        }, {
            sequelize,
            tableName: 'StudentTermlyResult',
            timestamps: false,
            indexes: [
                {
                    name: "PRIMARY",
                    unique: true,
                    using: "BTREE",
                    fields: [
                        { name: "studentTermlyResultId" },
                    ]
                },
                {
                    name: "fk_StudentTermlyResults_Student1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "studentId" },
                    ]
                },
                {
                    name: "fk_StudentTermlyResults_Class1_idx",
                    using: "BTREE",
                    fields: [
                        { name: "classId" },
                    ]
                },
            ]
        });
    }
}
exports.StudentTermlyResult = StudentTermlyResult;
