"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initModels = exports.User = exports.TermDetail = exports.Subject = exports.StudentTermlyResult = exports.StudentTermlyAttendance = exports.StudentMark = exports.StudentAttendance = exports.StudentFeeStatus = exports.Student = exports.Staff = exports.Section = exports.Parent = exports.Fees = exports.Income = exports.Expense = exports.ClassFee = exports.Class = exports.AccountCategory = void 0;
const sequelize_1 = __importDefault(require("../config/sequelize"));
const AccountCategory_1 = require("./AccountCategory");
Object.defineProperty(exports, "AccountCategory", { enumerable: true, get: function () { return AccountCategory_1.AccountCategory; } });
const Class_1 = require("./Class");
Object.defineProperty(exports, "Class", { enumerable: true, get: function () { return Class_1.Class; } });
const ClassFee_1 = require("./ClassFee");
Object.defineProperty(exports, "ClassFee", { enumerable: true, get: function () { return ClassFee_1.ClassFee; } });
const Expense_1 = require("./Expense");
Object.defineProperty(exports, "Expense", { enumerable: true, get: function () { return Expense_1.Expense; } });
const Income_1 = require("./Income");
Object.defineProperty(exports, "Income", { enumerable: true, get: function () { return Income_1.Income; } });
const Fees_1 = require("./Fees");
Object.defineProperty(exports, "Fees", { enumerable: true, get: function () { return Fees_1.Fees; } });
const Parent_1 = require("./Parent");
Object.defineProperty(exports, "Parent", { enumerable: true, get: function () { return Parent_1.Parent; } });
const Section_1 = require("./Section");
Object.defineProperty(exports, "Section", { enumerable: true, get: function () { return Section_1.Section; } });
const Staff_1 = require("./Staff");
Object.defineProperty(exports, "Staff", { enumerable: true, get: function () { return Staff_1.Staff; } });
const Student_1 = require("./Student");
Object.defineProperty(exports, "Student", { enumerable: true, get: function () { return Student_1.Student; } });
const StudentFeeStatus_1 = require("./StudentFeeStatus");
Object.defineProperty(exports, "StudentFeeStatus", { enumerable: true, get: function () { return StudentFeeStatus_1.StudentFeeStatus; } });
const StudentAttendance_1 = require("./StudentAttendance");
Object.defineProperty(exports, "StudentAttendance", { enumerable: true, get: function () { return StudentAttendance_1.StudentAttendance; } });
const StudentMark_1 = require("./StudentMark");
Object.defineProperty(exports, "StudentMark", { enumerable: true, get: function () { return StudentMark_1.StudentMark; } });
const StudentTermlyAttendance_1 = require("./StudentTermlyAttendance");
Object.defineProperty(exports, "StudentTermlyAttendance", { enumerable: true, get: function () { return StudentTermlyAttendance_1.StudentTermlyAttendance; } });
const StudentTermlyResult_1 = require("./StudentTermlyResult");
Object.defineProperty(exports, "StudentTermlyResult", { enumerable: true, get: function () { return StudentTermlyResult_1.StudentTermlyResult; } });
const Subject_1 = require("./Subject");
Object.defineProperty(exports, "Subject", { enumerable: true, get: function () { return Subject_1.Subject; } });
const TermDetail_1 = require("./TermDetail");
Object.defineProperty(exports, "TermDetail", { enumerable: true, get: function () { return TermDetail_1.TermDetail; } });
const User_1 = require("./User");
Object.defineProperty(exports, "User", { enumerable: true, get: function () { return User_1.User; } });
function initModels() {
    const AccountCategory = AccountCategory_1.AccountCategory.initModel(sequelize_1.default);
    const Class = Class_1.Class.initModel(sequelize_1.default);
    const ClassFee = ClassFee_1.ClassFee.initModel(sequelize_1.default);
    const Expense = Expense_1.Expense.initModel(sequelize_1.default);
    const Income = Income_1.Income.initModel(sequelize_1.default);
    const Fees = Fees_1.Fees.initModel(sequelize_1.default);
    const Parent = Parent_1.Parent.initModel(sequelize_1.default);
    const Section = Section_1.Section.initModel(sequelize_1.default);
    const Staff = Staff_1.Staff.initModel(sequelize_1.default);
    const Student = Student_1.Student.initModel(sequelize_1.default);
    const StudentFeeStatus = StudentFeeStatus_1.StudentFeeStatus.initModel(sequelize_1.default);
    const StudentAttendance = StudentAttendance_1.StudentAttendance.initModel(sequelize_1.default);
    const StudentMark = StudentMark_1.StudentMark.initModel(sequelize_1.default);
    const StudentTermlyAttendance = StudentTermlyAttendance_1.StudentTermlyAttendance.initModel(sequelize_1.default);
    const StudentTermlyResult = StudentTermlyResult_1.StudentTermlyResult.initModel(sequelize_1.default);
    const Subject = Subject_1.Subject.initModel(sequelize_1.default);
    const TermDetail = TermDetail_1.TermDetail.initModel(sequelize_1.default);
    const User = User_1.User.initModel(sequelize_1.default);
    Expense.belongsTo(AccountCategory, { as: "accountCategory", foreignKey: "accountCategoryId" });
    AccountCategory.hasMany(Expense, { as: "Expenses", foreignKey: "accountCategoryId" });
    Income.belongsTo(AccountCategory, { as: "accountCategory", foreignKey: "accountCategoryId" });
    AccountCategory.hasMany(Income, { as: "Incomes", foreignKey: "accountCategoryId" });
    Fees.belongsTo(Student, { as: "student", foreignKey: "studentId" });
    Student.hasMany(Fees, { as: "Fees", foreignKey: "studentId" });
    StudentFeeStatus.belongsTo(Student, { as: "student", foreignKey: "studentId" });
    Student.hasMany(StudentFeeStatus, { as: "StudentFeeStatus", foreignKey: "studentId" });
    Fees.belongsTo(Class, { as: "class", foreignKey: "classId" });
    Class.hasMany(Fees, { as: "Classes", foreignKey: "classId" });
    ClassFee.belongsTo(Class, { as: "class", foreignKey: "classId" });
    Class.hasMany(ClassFee, { as: "ClassFees", foreignKey: "classId" });
    Student.belongsTo(Class, { as: "class", foreignKey: "classId" });
    Class.hasMany(Student, { as: "Students", foreignKey: "classId" });
    StudentAttendance.belongsTo(Class, { as: "class", foreignKey: "classId" });
    Class.hasMany(StudentAttendance, { as: "StudentAttendances", foreignKey: "classId" });
    StudentAttendance.belongsTo(Class, { as: "student", foreignKey: "studentId" });
    Class.hasMany(StudentAttendance, { as: "student_StudentAttendances", foreignKey: "studentId" });
    StudentTermlyAttendance.belongsTo(Class, { as: "class", foreignKey: "classId" });
    Class.hasMany(StudentTermlyAttendance, { as: "StudentTermlyAttendances", foreignKey: "classId" });
    StudentTermlyResult.belongsTo(Class, { as: "class", foreignKey: "classId" });
    Class.hasMany(StudentTermlyResult, { as: "StudentTermlyResults", foreignKey: "classId" });
    Class.belongsTo(Section, { as: "section", foreignKey: "sectionId" });
    Section.hasMany(Class, { as: "Classes", foreignKey: "sectionId" });
    Class.belongsTo(Staff, { as: "staff", foreignKey: "staffId" });
    Staff.hasMany(Class, { as: "Classes", foreignKey: "staffId" });
    Expense.belongsTo(Staff, { as: "staff", foreignKey: "staffId" });
    Staff.hasMany(Expense, { as: "Expenses", foreignKey: "staffId" });
    Income.belongsTo(Staff, { as: "staff", foreignKey: "staffId" });
    Staff.hasMany(Income, { as: "Incomes", foreignKey: "staffId" });
    User.belongsTo(Staff, { as: "staff", foreignKey: "staffId" });
    Staff.hasMany(User, { as: "Users", foreignKey: "staffId" });
    Parent.belongsTo(Student, { as: "student", foreignKey: "studentId" });
    Student.hasMany(Parent, { as: "Parents", foreignKey: "studentId" });
    StudentTermlyAttendance.belongsTo(Student, { as: "student", foreignKey: "studentId" });
    Student.hasMany(StudentTermlyAttendance, { as: "StudentTermlyAttendances", foreignKey: "studentId" });
    StudentTermlyResult.belongsTo(Student, { as: "student", foreignKey: "studentId" });
    Student.hasMany(StudentTermlyResult, { as: "StudentTermlyResults", foreignKey: "studentId" });
    StudentMark.belongsTo(StudentTermlyResult, { as: "studentTermlyResult", foreignKey: "studentTermlyResultId" });
    StudentTermlyResult.hasMany(StudentMark, { as: "StudentMarks", foreignKey: "studentTermlyResultId" });
    StudentMark.belongsTo(Subject, { as: "subject", foreignKey: "subjectId" });
    Subject.hasMany(StudentMark, { as: "StudentMarks", foreignKey: "subjectId" });
    return {
        AccountCategory: AccountCategory,
        Class: Class,
        ClassFee: ClassFee,
        Expense: Expense,
        Income: Income,
        Fees: Fees,
        Parent: Parent,
        Section: Section,
        Staff: Staff,
        Student: Student,
        StudentFeeStatus: StudentFeeStatus,
        StudentAttendance: StudentAttendance,
        StudentMark: StudentMark,
        StudentTermlyAttendance: StudentTermlyAttendance,
        StudentTermlyResult: StudentTermlyResult,
        Subject: Subject,
        TermDetail: TermDetail,
        User: User,
    };
}
exports.initModels = initModels;
