"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrUpdateFeeStatus = exports.getAllFeeStatus = exports.getAllFees = exports.removeFee = exports.createFee = exports.removeIncome = exports.editIncome = exports.createIncome = exports.getAllIncome = exports.removeExpense = exports.editExpense = exports.createExpense = exports.getAllExpense = exports.removeAccountCategory = exports.createAccountCategory = exports.getAccountCategory = void 0;
const models_1 = require("../models");
//account category
const getAccountCategory = () => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.AccountCategory.findAll({ raw: true });
});
exports.getAccountCategory = getAccountCategory;
const createAccountCategory = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.AccountCategory.create(data);
});
exports.createAccountCategory = createAccountCategory;
const removeAccountCategory = (accountCategoryId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.AccountCategory.destroy({
        where: {
            accountCategoryId: accountCategoryId,
        },
    });
});
exports.removeAccountCategory = removeAccountCategory;
//expense
const getAllExpense = () => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Expense.findAll({
        include: [
            {
                model: models_1.AccountCategory,
                as: "accountCategory",
                attributes: ["name"],
            },
            {
                model: models_1.Staff,
                as: "staff",
                attributes: ["fName", "mName", "lName"],
            },
        ],
        order: [["expenseId", "DESC"]],
        // raw: true,
    });
});
exports.getAllExpense = getAllExpense;
const createExpense = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Expense.create(data);
});
exports.createExpense = createExpense;
const editExpense = (expenseId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Expense.update(data, {
        where: {
            expenseId: expenseId,
        },
    });
});
exports.editExpense = editExpense;
const removeExpense = (expenseId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Expense.destroy({
        where: {
            expenseId: expenseId,
        },
    });
});
exports.removeExpense = removeExpense;
//income
const getAllIncome = () => __awaiter(void 0, void 0, void 0, function* () {
    const result = yield models_1.Income.findAll({
        include: [
            {
                model: models_1.AccountCategory,
                as: "accountCategory",
                attributes: ["name"],
            },
            {
                model: models_1.Staff,
                as: "staff",
                attributes: ["fName", "mName", "lName"],
            },
        ],
        order: [["incomeId", "DESC"]],
        // raw: true,
    });
    // console.log(result)
    return result;
});
exports.getAllIncome = getAllIncome;
const createIncome = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Income.create(data);
});
exports.createIncome = createIncome;
const editIncome = (incomeId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Income.update(data, {
        where: {
            incomeId: incomeId,
        },
    });
});
exports.editIncome = editIncome;
const removeIncome = (incomeId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Income.destroy({
        where: {
            incomeId: incomeId,
        },
    });
});
exports.removeIncome = removeIncome;
//fees
const createFee = (data) => __awaiter(void 0, void 0, void 0, function* () {
    const _data = {
        studentId: data === null || data === void 0 ? void 0 : data.studentId,
        classId: data === null || data === void 0 ? void 0 : data.classId,
        total: data === null || data === void 0 ? void 0 : data.total,
        paid: data === null || data === void 0 ? void 0 : data.currentPaid,
        remaining: data === null || data === void 0 ? void 0 : data.remaining,
        paymentMode: data === null || data === void 0 ? void 0 : data.paymentMode,
        amountInWords: data === null || data === void 0 ? void 0 : data.amountInWords,
        datePaid: data === null || data === void 0 ? void 0 : data.datePaid,
        term: data === null || data === void 0 ? void 0 : data.term,
    };
    const updateData = {
        feeOwing: data === null || data === void 0 ? void 0 : data.remaining,
        feePaid: data === null || data === void 0 ? void 0 : data.totalPaid,
    };
    const result = yield models_1.Fees.create(_data);
    let studentRecord = yield models_1.StudentFeeStatus.findOne({
        where: {
            studentId: data.studentId,
        },
    });
    if (studentRecord) {
        // If the record exists, update it
        yield studentRecord.update(updateData);
    }
    else {
        // If it doesn't exist, create a new record
        yield models_1.StudentFeeStatus.create(Object.assign({ studentId: data.studentId }, updateData));
    }
    return result;
});
exports.createFee = createFee;
const removeFee = (data) => __awaiter(void 0, void 0, void 0, function* () {
    const result = yield models_1.Fees.destroy({
        where: {
            feeId: data.feeId,
        },
    });
    // const updateData = {
    //   feeOwing: data?.remaining,
    //   feePaid: data?.totalPaid,
    // };
    let studentRecord = yield models_1.StudentFeeStatus.findOne({
        where: {
            studentId: data.studentId,
        },
    });
    if (studentRecord) {
        const newFeeOwing = Number(studentRecord.feeOwing) + Number(data.paid);
        const newFeePaid = Number(studentRecord.feePaid) - Number(data.paid);
        console.log(newFeeOwing, newFeePaid);
        // If the record exists, update it
        yield studentRecord.update({
            feeOwing: newFeeOwing,
            feePaid: newFeePaid,
        });
    }
    return result;
});
exports.removeFee = removeFee;
const getAllFees = () => __awaiter(void 0, void 0, void 0, function* () {
    const result = yield models_1.Fees.findAll({
        include: [
            {
                model: models_1.Student,
                as: "student",
                attributes: ["fName", "mName", "lName"],
            },
            {
                model: models_1.Class,
                as: "class",
                attributes: ["name"],
            },
        ],
        order: [["feeId", "DESC"]],
        // raw: true,
    });
    // console.log(result)
    return result;
});
exports.getAllFees = getAllFees;
//fee status
const getAllFeeStatus = () => __awaiter(void 0, void 0, void 0, function* () {
    const result = yield models_1.StudentFeeStatus.findAll({
        include: [
            {
                model: models_1.Student,
                as: "student",
                attributes: ["fName", "mName", "lName"],
            }
        ],
        order: [["feeOwing", "DESC"]],
        // raw: true,
    });
    // console.log(result)
    return result;
});
exports.getAllFeeStatus = getAllFeeStatus;
const createOrUpdateFeeStatus = (data) => __awaiter(void 0, void 0, void 0, function* () {
    let studentRecord = yield models_1.StudentFeeStatus.findOne({
        where: {
            studentId: data.studentId,
        },
    });
    let result;
    if (studentRecord) {
        // If the record exists, update it
        result = yield studentRecord.update({
            feeOwing: data.feeOwing
        });
    }
    else {
        // If it doesn't exist, create a new record
        result = yield models_1.StudentFeeStatus.create({
            studentId: data.studentId,
            feeOwing: data.feeOwing,
            feePaid: 0.00
        });
    }
    return result;
});
exports.createOrUpdateFeeStatus = createOrUpdateFeeStatus;
