"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeClassFee = exports.editClassFee = exports.createClassFee = exports.getClassFee = exports.removeSection = exports.createSection = exports.getAllSection = exports.removeClass = exports.editClass = exports.createClass = exports.getClassById = exports.getAllClass = void 0;
const sequelize_1 = __importDefault(require("../config/sequelize"));
const models_1 = require("../models");
const getAllClass = () => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Class.findAll({
        include: [
            {
                model: models_1.Section,
                as: "section",
                attributes: ["name"],
            },
            {
                model: models_1.Staff,
                as: "staff",
                attributes: ["fName", "mName", "lName"],
            },
            {
                model: models_1.ClassFee,
                as: "ClassFees",
            },
        ],
        attributes: {
            include: [
                [sequelize_1.default.literal('(SELECT COUNT(*) FROM Student WHERE Student.classId = Class.classId)'), 'capacity']
            ]
        }
    });
});
exports.getAllClass = getAllClass;
const getClassById = (classId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Class.findByPk(classId, {
        include: [
            {
                model: models_1.Section,
                as: "section",
                attributes: ["name"],
            },
            {
                model: models_1.ClassFee,
                as: "ClassFees",
            },
        ],
    });
});
exports.getClassById = getClassById;
const createClass = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Class.create(data);
});
exports.createClass = createClass;
const editClass = (classId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Class.update(data, {
        where: {
            classId: classId,
        },
    });
});
exports.editClass = editClass;
const removeClass = (classId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Class.destroy({
        where: {
            classId: classId,
        },
    });
});
exports.removeClass = removeClass;
//section
const getAllSection = () => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Section.findAll();
});
exports.getAllSection = getAllSection;
const createSection = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Section.create(data);
});
exports.createSection = createSection;
const removeSection = (sectionId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Section.destroy({
        where: {
            sectionId: sectionId,
        },
    });
});
exports.removeSection = removeSection;
//class fees
const getClassFee = (classId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.ClassFee.findAll({
        where: {
            classId: classId,
        },
    });
});
exports.getClassFee = getClassFee;
const createClassFee = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.ClassFee.create(data);
});
exports.createClassFee = createClassFee;
const editClassFee = (classFeeId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.ClassFee.update(data, {
        where: {
            classId: data.classId,
            classFeesId: classFeeId,
        },
    });
});
exports.editClassFee = editClassFee;
const removeClassFee = (classFeeId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.ClassFee.destroy({
        where: {
            classFeesId: classFeeId,
        },
    });
});
exports.removeClassFee = removeClassFee;
