"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.editParent = exports.createParent = exports.removeStudent = exports.editStudent = exports.createStudent = exports.getStudentById = exports.getAllStudents = void 0;
const models_1 = require("../models");
const getAllStudents = () => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Student.findAll({
        include: [
            {
                model: models_1.Class,
                as: "class",
                attributes: ["name"],
                include: [
                    {
                        as: "ClassFees",
                        model: models_1.ClassFee,
                    }
                ]
            },
            {
                model: models_1.Parent,
                as: "Parents",
            }
        ]
    });
});
exports.getAllStudents = getAllStudents;
const getStudentById = (studentId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Student.findByPk(studentId, {
        include: [
            {
                model: models_1.Class,
                as: "class",
                attributes: ["name"]
            },
            {
                model: models_1.Parent,
                as: "Parents",
            }
        ]
    });
});
exports.getStudentById = getStudentById;
const createStudent = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Student.create(data);
});
exports.createStudent = createStudent;
const editStudent = (studentId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Student.update(data, {
        where: {
            studentId: studentId,
        },
    });
});
exports.editStudent = editStudent;
const removeStudent = (studentId) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Student.destroy({
        where: {
            studentId: studentId,
        },
    });
});
exports.removeStudent = removeStudent;
//parents
const createParent = (data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Parent.create(data);
});
exports.createParent = createParent;
const editParent = (studentId, data) => __awaiter(void 0, void 0, void 0, function* () {
    return yield models_1.Parent.update(data, {
        where: {
            studentId: studentId,
        },
    });
});
exports.editParent = editParent;
