"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const passport_1 = __importDefault(require("passport"));
const passport_local_1 = require("passport-local");
const bcrypt_1 = __importDefault(require("bcrypt"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const services_1 = require("../services");
const secretKey = "rc mensah school";
passport_1.default.use(new passport_local_1.Strategy({
    usernameField: "username",
    passwordField: "password",
}, (username, password, done) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    try {
        const userDetails = {
            username: username,
            password: password,
        };
        // console.log("Login:::", userDetails)
        const user = yield (0, services_1.getUser)(userDetails);
        // console.log(user);
        if (!user) {
            return done(null, false, { message: "Invalid username or password" });
        }
        // console.log({message: "User found"});
        if (!bcrypt_1.default.compareSync(password, user.password)) {
            return done(null, false, { message: "Invalid username or password" });
        }
        // console.log({message: "Correct password yoooorrr"})
        const payload = {
            username: user.username,
            staffId: user.staffId,
            role: (_a = user.staff) === null || _a === void 0 ? void 0 : _a.category,
            staff: user.staff,
        };
        const token = jsonwebtoken_1.default.sign(payload, secretKey, {
            expiresIn: "3d",
        });
        return done(null, user, {
            message: "Logged in successfully",
            token: token,
        });
    }
    catch (error) {
        return done(error);
    }
})));
exports.default = passport_1.default;
